﻿using System;
using System.Web.Mvc;
using MVC_App.Models;
using MVC_App.Validation;

namespace MVC_App.Controllers
{
	public partial class HomeController : Controller
	{
		private KreditkarteZahlungModel ValidateKreditkarteZahlung(BestellungForm bestellung)
		{
			var v = ModelStateValidator.Build(ModelState, bestellung).MoveToNode(p => p.Kreditkarte);

			var vName = v.Validate(p => p.Name).NotNullOrWhitespace();
			string name = vName;
			var vNummer = v.Validate(p => p.Nummer).NotNullOrWhitespace();
			string nummer = vNummer;

			var vMonat = v.Validate(p => p.GültigBisMonat).NotNullOrWhitespace().ToInt32().InRange(1, 12);
			var vJahr = v.Validate(p => p.GültigBisJahr).NotNullOrWhitespace().ToInt32().InRange(2012, 2020);

			DateTime gültigkeit = default(DateTime);
			if (vMonat.DoEvaluate && vJahr.DoEvaluate)
			{
				gültigkeit = new DateTime(vJahr.Value, vMonat.Value, 1);
			}

			if (vName.DoEvaluate
				&& vNummer.DoEvaluate
				&& gültigkeit != default(DateTime))
			{
				// Dritte Validierungsebene: Semantische Korrektheit des gesamten Typs
				var result = KreditkarteServiceGateway.CheckValidity(
					vName.Value,
					vNummer.Value,
					gültigkeit);

				if (result == null)
				{
					ModelState.AddModelError("Kreditkarte.Name", "Die Kreditkarteninformationen sind ungültig");
					ModelState.AddModelError("Kreditkarte.Nummer", "");
					ModelState.AddModelError("Kreditkarte.GültigBisMonat", "");
					ModelState.AddModelError("Kreditkarte.GültigBisJahr", "");
				}
			}

			return null;
		}
	}
}
